---
title: Lecture 51：函数展开成幂级数
tags:
  - 数学
  - 无穷级数
categories: 
date: 2024-02-15
---
---
## 51.1 函数展开成幂级数
### 51.1.1 基本概念
**为什么需要展开成幂级数**
+ 原因：
	+ 有些函数不是初等函数、不可以直接使用积分求出来它的值，比如 $e^{x^2}$ 其无法直接求出其原函数；
	+ 此时可以考虑：将其展开成幂级数，因为幂级数的每一项都很简单，因此可以被处理；
+ 举例：比如需要求 $e^{0.2}$ 等于多少
	+ 直接求很难算出来；
	+ 但利用展开后的幂级数，计算出来就很简单： $e^{x}=1+x+\frac{x^{2}}{2!}+\frac{x^{3}}{3!}+\cdots+\frac{x^{n}}{n!}+$
	+ 后续的项可以近似得到，一般就用个三项、四项就够了；

##### **定理**： #函数的幂级数展开
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> 如果函数 $f(x)$ 在区间 $(x_0-R,x_0+R)$ 上，能展开为 $x-x_0$ 的幂级数 $f(x)=\sum_{n=0}^{+\infty} a_n(x-x_0)^n$ 则，其展开式是唯一的；
> 并且称其为 $f(x)$ 在 $x=x_0$ 处的**泰勒级数**：$$\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n$$

**解释**
+ 如果 $\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n$ 可以收敛于 $f(x)$，则称其可以展开；

##### **定理**： #泰勒级数的收敛性
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> 设 $f(x)$ 在 $x=x_0$ 处任意阶可导，则：
> $$\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n 在 (x_0-R,x_0+R) 上收敛于 f(x)\Leftrightarrow\lim_{n\to\infty} R_n(x)=0.$$
> 其中：$$\begin{aligned}&R_n(x)=\frac{f^{(n+1)}(\xi)}{(n+1)!}(x-x_0)^{n+1}\text{ 为 }f(x)\text{ 在 }x_0\text{ 处的泰勒公式}\\&f(x)=\sum_{k=0}^n\frac{f^{(k)}(x_0)}{k!}(x-x_0)^k+R_n(x)\end{aligned}$$
> 所以当 $R_n(x)$ `->` `0` 时，$f(x)$ 趋向于泰勒级数：$\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n$，即收敛于唯一的级数；

### 51.1.2 常用幂级数展开式
**补充**：几个常用的展开式
+ 直接展开法：
	+ （1）$$\frac1{1-x}=1+x+x^2+\cdots+x^n+\cdots =\sum^{\infty}\limits_{n=0}x^n\quad (-1<x<1)$$
	+ （2）$$\frac1{1+x}=\sum_{n=0}^\infty(-1)^nx^n,|x|<1$$
	+ （3）$$\sin x=x-\frac{x^3}{3!}+\cdots+\frac{(-1)^{n}x^{2n+1}}{(2n+1)!}+\cdots=\sum_{n=0}^{\infty}\frac{(-1)^n}{(2n+1)!}x^{2n+1} \quad(-\infty<x<+\infty)$$
		+ 注意：求和下标从 0 开始，`(-1)` 是指数是 `n`；
	+ （4） $$e^x=1+x+\frac{x^2}{2!}+\cdots+\frac{x^n}{n!}+\cdots \quad (-\infty<x<+\infty)=\sum^{\infty}\limits_{n=0}\frac{x^n}{n！}$$
+ 间接展开法：
	+ （1）`cosx` 的展开式，是由 `sinx` 的展开式逐项求导而的来的：$$\cos x=1-\frac{x^2}{2!}+\cdots+\frac{(-1)^{n-1}x^{2n}}{(2n)!}+\cdots=\sum_{n=0}^{\infty}\frac{(-1)^n}{(2n)!}x^{2n}   \quad(-\infty<x<+\infty)$$
	+ （2）`In(1+x)` 的展开式：$$\ln(1+x)=x-\frac{x^2}2+\cdots+\frac{(-1)^{n+1}x^n}n+\cdots=\sum_{n=1}^{\infty}\frac{(-1)^{n+1}}{n}x^{n}\quad(-1<x\leq1)$$
	+ （3）`(1+X)的α次方` 的展开式，也是间接得到的：$$\left(1+x\right)^\alpha=1+\alpha x+\frac{\alpha(\alpha-1)}{2!}x^2+\cdots+\frac{\alpha(\alpha-1)\cdots(\alpha-n+1)}{n!}x^n+\cdots \quad(-1<x<1)$$
	+ (4) $$\sum_{n=1}^{\infty}\frac{x^{n}}n=-\ln(1-x)\quad(-1\leq x<1)$$
+ 注意： 
	+ 关于下标：除了 `In(1+x)` 是从 `n=1` 开始的，其他都是从 `n=0` 开始的； 
	+ 关于 $(-1)^{n}$ 和 $(-1)^{n+1}$：只有 `In(1+x)` 是 `n+1` ，其他都是从 `n`；
	+ 关于阶乘：除了 `In(1+x)` 的分母是非阶乘，其他带分母的都是阶乘，并且阶乘部分和幂指部分一致；
	+ 关于收敛域：三角函数和 $e^{x}$ 是负无穷到正无穷，其他都是 `-1` 到 `+1`，并且 `In(1+x)` 是小于等于 `+1`；


### 51.1.3 函数展开为幂级数的两种方法
**方法一**：直接展开法
+ 第一步：算出这一点的 `n` 阶导数，代入进来，写出它的泰勒级数： $$f(x)\sim\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n$$
+ 第二步：$$考察\lim_{n\to\infty}R_n(x)=\lim_{n\to\infty}\frac{f^{(n+1)}(\xi)}{(n+1)!}(x-x_0)^{n+1}=0 是否成立$$

**方法二**：间接展开法
+ 原理：
	+ 根据函数展开为幂级数的唯一性，可知可以从某些已知函数展开式出发，利用幂级数的性质 (四则运算，逐项求导，逐项积分)及变量代换等方法，求得所给函数的展开式；

## 51.2 常考题型

---
### 题型： #将函数展开为幂级数 
#### PART 1：解题方法
**总结**
+ 1. 因为直接展开法十分复杂，一般先思考是否可以间接展开；

**题型**：将函数 $f(x)$ 展开为 $x=x_0$ 处的幂级数
+ 需要在使用间接展开的时候、将函数中的关于 `x` 的函数凑成 $x-x_0$ 的形式
+ 举例：求 $f(x)=sinx$ 在 $x=\frac{{\pi}}{4}$ 处展开为幂级数 `->` 转化：$$f(x)=sin[\frac{{\pi}}{4}+(x-\frac{{\pi}}{4})]=...$$

#### PART 2：典型例题

#### PART 3：知识点复盘
**知识点**：$\frac1{1-x}$ 和 $\frac1{1+x}$ 的活用
+ 为了可以使用以上两个幂级数的展开式，经常需要将式子变化成以下形式：
	+ $$\frac1{1-\fbox{fun(x)}}和\frac1{1+\fbox{fun(x)}}$$
+ 其中 $\fbox{fun (x)}$ 表示一个关于 `x` 的式子；


---
### 题型： #级数求和 
#### PART 1：解题方法
**总结**；展开式与求和式
+ 概念：
	+ 总结：
		+ 求和和展开的理论式性质是一样的，只不过一个是往右用，一个是往左用；
	+ 假设有： $$\frac{1}{{1-x}}=1+x+x^2+...$$
	+ 展开式：
		+ $$\frac{1}{{1-x}}\rightarrow1+x+x^2+...$$
	+ 求和式：
		+ $$S(x)=\frac{1}{{1-x}}\leftarrow1+x+x^2+...$$
+ 幂函数列 `->` 和函数：
	+ 找已有的级数中、它的形式和哪个已有的展开式比较接近；

#### PART 2：典型例题

#### PART 3：知识点复盘
**知识点**：关于 `In` 
+ $$\sum_{n=1}^{\infty}\frac{x^{n}}n=-\ln(1-x)\left(-1\leq x<1\right)$$